---
title: Pricing · Cloudflare Stream docs
description: "Cloudflare Stream lets you broadcast, store, and deliver video
  using a simple, unified API and simple pricing. Stream bills on two dimensions
  only:"
lastUpdated: 2025-09-25T13:29:38.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/stream/pricing/
  md: https://developers.cloudflare.com/stream/pricing/index.md
---

Media Transformations is now GA:

Billing for Media Transformations will begin on November 1st, 2025.

## Pricing for Stream

Cloudflare Stream lets you broadcast, store, and deliver video using a simple, unified API and simple pricing. Stream bills on two dimensions only:

* **Minutes of video stored:** the total duration of uploaded video and live recordings
* **Minutes of video delivered:** the total duration of video delivered to end users

On-demand and live video are billed the same way.

Ingress (sending your content to us) and encoding are always free. Bandwidth is already included in "video delivered" with no additional egress (traffic/bandwidth) fees.

### Minutes of video stored

Storage is a prepaid pricing dimension purchased in increments of $5 per 1,000 minutes stored, regardless of file size. You can check how much storage you have and how much you have used on the **Stream** page of the Cloudflare dashboard.

[Go to **Stream**](https://dash.cloudflare.com/?to=/:account/stream)

Storage is consumed by:

* Original videos uploaded to your account
* Recordings of live broadcasts
* The reserved `maxDurationSeconds` for Direct Creator and TUS uploads which have not been completed. After these uploads are complete or the upload link expires, this reservation is released.

Storage is not consumed by:

* Videos in an unplayable or errored state
* Expired Direct Creator upload links
* Deleted videos
* Downloadable files generated for [MP4 Downloads](https://developers.cloudflare.com/stream/viewing-videos/download-videos/)
* Multiple quality levels that Stream generates for each uploaded original

Storage consumption is rounded up to the second of video duration; file size does not matter. Video stored in Stream does not incur additional storage fees from other storage products such as R2.

Note

If you run out of storage, you will not be able to upload new videos or start new live streams until you purchase more storage or delete videos.

Enterprise customers *may* continue to upload new content beyond their contracted quota without interruption.

### Minutes of video delivered

Delivery is a post-paid, usage-based pricing dimension billed at $1 per 1,000 minutes delivered. You can check how much delivery you have used on the **Billing** page or the Stream **Analytics** page of the Cloudflare dashboard.

[Go to **Billing** ](https://dash.cloudflare.com/?to=/:account/billing)[Go to **Analytics**](https://dash.cloudflare.com/?to=/:account/stream/analytics)

Delivery is counted for the following uses:

* Playback on the web or an app using [Stream's built-in player](https://developers.cloudflare.com/stream/viewing-videos/using-the-stream-player/) or the [HLS or DASH manifests](https://developers.cloudflare.com/stream/viewing-videos/using-own-player/)
* MP4 Downloads
* Simulcasting via SRT or RTMP live outputs

Delivery is counted by HTTP requests for video segments or parts of the MP4. Therefore:

* Client-side preloading and buffering is counted as billable delivery.
* Content played from client-side/browser cache is *not* billable, like a short looping video. Some mobile app player libraries do not cache HLS segments by default.
* MP4 Downloads are billed by percentage of the file delivered.

Minutes delivered for web playback (Stream Player, HLS, and DASH) are rounded to the *segment* length: for uploaded content, segments are four seconds. Live broadcast and recording segments are determined by the keyframe interval or GOP size of the original broadcast.

### Example scenarios

**Two people each watch thirty minutes of a video or live broadcast. How much would it cost?**

This will result in 60 minutes of Minutes Delivered usage (or $0.06). Stream bills on total minutes of video delivered across all users.

**I have a really large file. Does that cost more?**

The cost to store a video is based only on its duration, not its file size. If the file is within the [30GB max file size limitation](https://developers.cloudflare.com/stream/faq/#is-there-a-limit-to-the-amount-of-videos-i-can-upload), it will be accepted. Be sure to use an [upload method](https://developers.cloudflare.com/stream/uploading-videos/) like Upload from Link or TUS that handles large files well.

**If I make a Direct Creator Upload link with a maximum duration (`maxDurationSeconds`) of 600 seconds which expires in 1 hour, how is storage consumed?**

* Ten minutes (600 seconds) will be subtracted from your available storage immediately.
* If the link is unused in one hour, those 10 minutes will be released.
* If the creator link is used to upload a five minute video, when the video is uploaded and processed, the 10 minute reservation will be released and the true five minute duration of the file will be counted.
* If the creator link is used to upload a five minute video but it fails to encode, the video will be marked as errored, the reserved storage will be released, and no storage use will be counted.

**I am broadcasting live, but no one is watching. How much does that cost?**

A live broadcast with no viewers will cost $0 for minutes delivered, but the recording of the broadcast will count toward minutes of video stored.

If someone watches the recording, that will be counted as minutes of video delivered.

If the recording is deleted, the storage use will be released.

**I want to store and deliver millions of minutes a month. Do you have volume pricing?**

Yes, contact our [Sales Team](https://www.cloudflare.com/plans/enterprise/contact/).

## Pricing for Media Transformations

After November 1st, 2025, Media Transforamtions and Image Transformations will use the same subscriptions and usage metrics.

* Generating a still frame (single image) from a video counts as 1 transformation.
* Generating an optimized video or extracting audio counts as 1 transformation *per second of the output* content.
* Each unique transformation, as determined by input and unique combination of flags, is only billed once per calendar month.
* All Media and Image Transformations cost $0.50 per 1,000 monthly unique transformation operations, with a free monthly allocation of 5,000.
